#pragma once

#include <list>

#include "GameObject.h"



class Level
{

  public:

    typedef std::list<GameObject>   tListObjects;

    tListObjects            m_Objects;

    LD10::TileTypes         m_Field[32][22];

    int                     m_BombsAvailable;

    float                   m_PhysicsStep;

    bool                    m_Solved;

    std::string             m_Name;

    int                     m_CurBombNumber;

    int                     m_ObjIndex;


    Level();
    ~Level();


    void                    Render();
    void                    Update( float ElapsedTime );

    bool                    Load( int Nr );
    bool                    Save( int Nr );

    void                    Clear();

    GameObject*             CreateObject( LD10::GameObjectType ObjType );

    void                    RemoveObject( GameObject* pObj );

    bool                    MoveObject( GameObject* pObj, float DX, float DY );
    bool                    IsBlocked( GameObject* pObj, int X, int Y, int W, int H );

    bool                    IsAreaGoal( int X, int Y, int W, int H );
    bool                    IsSolved();

    bool                    CanAreaContainBomb( int X, int Y, int W, int H );

};
